/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xpci.h
 * -----------------------------------------------------------------*/

#ifndef XPCI_H_INCLUDED
#define XPCI_H_INCLUDED

#include <xtypedef.h>
#include <xio.h>
#include <b_pci.h>

/* */

#ifdef DOSW32
#include <dos.h> /* used for sleep (msecs.) */
/***********************************************************/
/* Prototypes for PCI-functions in Extended DOS (xpci16.c) */
/***********************************************************/
bx_int32 ReadPCIDWord(bx_int32 Reg_N,bx_int32 DeviceNumber);
void WritePCIDWord(bx_int32 Reg_N, bx_int32 DeviceNumber, bx_int32 Value);
bx_int16 ReadPCIWord(bx_int32 Reg_N, bx_int32 DeviceNumber);
void WritePCIWord(bx_int32 Reg_N, bx_int32 DeviceNumber, bx_int16 Value);
bx_int8 ReadPCIByte(bx_int32 Reg_N, bx_int32 DeviceNumber);
void WritePCIByte(bx_int32 Reg_N, bx_int32 DeviceNumber, bx_int8 Value);

#endif

/* these functions are in pci32.c */

/* --------------------------------------------------------------------------
 * Exported functions 
 * -------------------------------------------------------------------------- */

  bx_errtype EXPORT BestXGenericPCIDWSet(
  bx_int32 dwHPSlotId,
  bx_int32 Reg_N,
  bx_int32 value);

  bx_errtype EXPORT BestXGenericPCIDWGet(
  bx_int32 dwHPSlotId,
  bx_int32 Reg_N,
  bx_int32 * pResult);

  bx_errtype EXPORT BestXClosePCI(
  bx_portnumtype OsHandle);

/* --------------------------------------------------------------------------
 * Standard I/O functions (see iocommon.c)
 * -------------------------------------------------------------------------- */

  bx_errtype BestXPCISetRegwidth(bx_portnumtype OsHandle, int regwidth);
  bx_errtype BestXPCIDeviceConnect(bx_portnumtype OsHandle);
  bx_errtype BestXPCICheckConnection(bx_portnumtype OsHandle);
void BestXPCIReleaseConnection(bx_portnumtype OsHandle);
  bx_errtype BestXPciPortTimeoutSet(bx_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts);

/* ----------------------------------------------------------------------------
 * ISP access using MemRd/MemWr
 * ------------------------------------------------------------------------- */

bx_errtype EXPORT BestXGetISPDWMem(
    bx_int32 Reg_N,              /* offset - only valid ISP offsets should be passed */
    bx_portnumtype OsHandle,
    bx_int32* pResult);

bx_errtype EXPORT BestXSetISPDWMem(
    bx_int32 Reg_N,              /* offset - only valid ISP offsets should be passed */
    bx_portnumtype OsHandle,
    bx_int32 value);

/* Default timeouts are defined in bx_io.h */

/* --------------------------------------------------------------------------
 * Other exposed functions
 * -------------------------------------------------------------------------- */

  bx_errtype EXPORT BestXOpenPCI(
    int portnum,
  bx_portnumtype * pOsHandle);

  bx_errtype BestXOpenIO(
    int portnum,
  bx_portnumtype * pOsHandle);

  bx_errtype BestXPCIMailboxWrite(
  bx_int32 dwHPSlotId,
  bx_int32 value);

  bx_errtype BestXPCIMailboxRead(
  bx_int32 dwHPSlotId,
  bx_int32 * pResult);

  bx_errtype BestXGetHPSlotIdFromOsHandle(
  bx_portnumtype OsHandle,
  bx_int32 * pdwHPSlotId);

  bx_errtype BestXPciDevMultiFuncCheck(
  bx_int32 dwHPSlotId,
  bx_bool * fIsMultiFunc);

struct BEST_SLOT
{
  union
  {
    struct
    {
      unsigned int Function:3;
      unsigned int Slot:5;
      unsigned int BusNumber:8;
    } bits;
  bx_int32 Combined;
  } u;
};

typedef struct BEST_SLOT BEST_SLOT;


/* --------------------------------------------------------------------------
 * These declarations are not always used (OS-DEPENDENT)
 * -------------------------------------------------------------------------- */

  bx_errtype BestXPciBasicRead(
  bx_handletype handle,
  bx_int8ptr pData,
  bx_int32 NumBytes,
  bx_int32 * NumBytesRead);

  bx_errtype BestXPciBasicWrite(
  bx_handletype handle,
  bx_int8ptr pData,
  bx_int32 NumBytes,
  bx_int32 * NumBytesWritten);

/* direct access to hardware via access port */
bx_errtype EXPORT BestXDirectRegPCIRead(
  bx_handletype handle,
  bx_int32 dir_addr,
  bx_int32 regsize,
  bx_int32 *reg_value
);

/* direct access to hardware via access port */
bx_errtype EXPORT BestXDirectRegPCIWrite(
  bx_handletype handle,
  bx_int32 dir_addr,
  bx_int32 regsize,    
  bx_int32 reg_value
);

#endif
